module rf_section (GND, VBAT_REG, VBAT_PA, Vio,
		   Analog_IM, Analog_IP, Analog_QM, Analog_QP, AFC, APC,
		   TCXOEN, RFEN, TSPCLK, TSPDO, TSPEN_Rita, TSPACT,
		   Clock_out_to_DBB, RTEMP_VTEST, ANTENNA);

input GND, VBAT_REG, VBAT_PA, Vio;

inout Analog_IM, Analog_IP, Analog_QM, Analog_QP;
input AFC, APC;
input TCXOEN, RFEN, TSPCLK, TSPDO, TSPEN_Rita;
input [11:0] TSPACT;

output Clock_out_to_DBB, RTEMP_VTEST;
inout ANTENNA;

/* wires between subblocks */
wire VREG3;
wire LNAGSMN, LNAGSMP, LNADCSN, LNADCSP, LNAPCSN, LNAPCSP;
wire Rita_LBTXOUT, Rita_HBTXOUT;
wire PA_LB_in, PA_HB_in, PA_LB_out, PA_HB_out;
wire FEM_TX_LB_in, FEM_TX_HB_in;
wire FEMout_to_LNAGSMN, FEMout_to_LNAGSMP;
wire FEMout_to_LNADCSN, FEMout_to_LNADCSP;
wire FEMout_to_LNAPCSN, FEMout_to_LNAPCSP;

/* instantiate the main subblocks */

rita_vcxo_int Rita_vcxo (.GND(GND),
			 .VBAT(VBAT_REG),
			 .VREG3(VREG3),
			 .VRIO(Vio),
			 .TCXOEN(TCXOEN),
			 .RFEN(RFEN),
			 .AFC_in(AFC),
			 .Clock_out_to_DBB(Clock_out_to_DBB),
			 .Ctrl_CLK(TSPCLK),
			 .Ctrl_DATA(TSPDO),
			 .Ctrl_STROBE(TSPEN_Rita),
			 .Ctrl_RESETZ(TSPACT[0]),
			 .IN(Analog_IM),
			 .IP(Analog_IP),
			 .QN(Analog_QM),
			 .QP(Analog_QP),
			 .LNAGSMN(LNAGSMN),
			 .LNAGSMP(LNAGSMP),
			 .LNADCSN(LNADCSN),
			 .LNADCSP(LNADCSP),
			 .LNAPCSN(LNAPCSN),
			 .LNAPCSP(LNAPCSP),
			 .LBTXOUT(Rita_LBTXOUT),
			 .HBTXOUT(Rita_HBTXOUT),
			 .DAC(GND),
			 .DET1(GND),
			 .DET2(GND),
			 .APC(),		/* no connect */
			 .RTEMP_VTEST(RTEMP_VTEST)
	);

rf_pa_block PA (.GND(GND),
		.VBAT(VBAT_PA),
		.Band_Select(TSPACT[3]),
		.Tx_Enable(TSPACT[9]),
		.APC_in(APC),
		.LB_RF_in(PA_LB_in),
		.HB_RF_in(PA_HB_in),
		.LB_RF_out(PA_LB_out),
		.HB_RF_out(PA_HB_out)
	);

rf_fem_block FEM (.GND(GND),
		  .VREG3(VREG3),
		  .Om_TSPACT2(TSPACT[2]),
		  .Om_TSPACT1(TSPACT[1]),
		  .Om_TSPACT4(TSPACT[4]),
		  .GSMout_neg(FEMout_to_LNAGSMN),
		  .GSMout_pos(FEMout_to_LNAGSMP),
		  .DCSout_neg(FEMout_to_LNADCSN),
		  .DCSout_pos(FEMout_to_LNADCSP),
		  .PCSout_neg(FEMout_to_LNAPCSN),
		  .PCSout_pos(FEMout_to_LNAPCSP),
		  .TX_LOW(FEM_TX_LB_in),
		  .TX_HIGH(FEM_TX_HB_in),
		  .ANT(ANTENNA)
	);

/* RF magic glue connecting the blocks */

/* Tx: Rita to PA */
rfmatch_rita2pa_lb rita2pa_lb (.In(Rita_LBTXOUT), .Out(PA_LB_in), .GND(GND));
rfmatch_rita2pa_hb rita2pa_hb (.In(Rita_HBTXOUT), .Out(PA_HB_in), .GND(GND),
				.VREG3(VREG3));

/* Tx: PA to antenna switch */
rfmatch_pa2antsw_lb pa2antsw_lb (.In(PA_LB_out), .Out(FEM_TX_LB_in), .GND(GND));
rfmatch_pa2antsw_hb pa2antsw_hb (.In(PA_HB_out), .Out(FEM_TX_HB_in), .GND(GND));

/* Rx paths (3) from the RFFE to Rita LNA inputs */

rfmatch_fem2rita_om fem2rita_low (.In_neg(FEMout_to_LNAGSMN),
				  .In_pos(FEMout_to_LNAGSMP),
				  .Out_neg(LNAGSMN),
				  .Out_pos(LNAGSMP)
			);
rfmatch_fem2rita_om fem2rita_dcs (.In_neg(FEMout_to_LNADCSN),
				  .In_pos(FEMout_to_LNADCSP),
				  .Out_neg(LNADCSN),
				  .Out_pos(LNADCSP)
			);
rfmatch_fem2rita_om fem2rita_pcs (.In_neg(FEMout_to_LNAPCSN),
				  .In_pos(FEMout_to_LNAPCSP),
				  .Out_neg(LNAPCSN),
				  .Out_pos(LNAPCSP)
			);

endmodule
