/*
 * This module encapsulates the RF PA along with its power bypass caps
 * and the Rs and Cs on the control inputs.
 */

module rf_pa_block (GND, VBAT, Band_Select, Tx_Enable, APC_in,
			LB_RF_in, HB_RF_in, LB_RF_out, HB_RF_out);

input GND, VBAT;
input Band_Select, Tx_Enable, APC_in;
input LB_RF_in, HB_RF_in;
output LB_RF_out, HB_RF_out;

/*
 * A little bit of muck with the control inputs,
 * exactly following Leonardo and Openmoko schematics.
 */

wire Band_Select_after_0R;
wire Tx_Enable_after_0R;
wire APC_after_resistor;

resistor R621 (Band_Select, Band_Select_after_0R);
resistor R622 (Tx_Enable, Tx_Enable_after_0R);
resistor R623 (APC_in, APC_after_resistor);
capacitor C648 (APC_after_resistor, GND);
capacitor C656 (Band_Select_after_0R, GND);

/* instantiate the PA itself */

RF3166 PA (.HB_RF_in(HB_RF_in),
	   .Band_Select(Band_Select_after_0R),
	   .Tx_Enable(Tx_Enable_after_0R),
	   .Vbatt(VBAT),
	   .GND(GND),
	   .Vramp(APC_after_resistor),
	   .LB_RF_in(LB_RF_in),
	   .LB_RF_out(LB_RF_out),
	   .HB_RF_out(HB_RF_out)
	);

/* 4 bypass caps per both Leonardo and Openmoko schematics */

capacitor C651 (VBAT, GND);
capacitor C652 (VBAT, GND);
capacitor C653 (VBAT, GND);
capacitor C654 (VBAT, GND);

endmodule
