module memory  (GND, Vflash, Vsram,
		MCU_A, MCU_D, MCU_nRD, MCU_nWR, MCU_nBHE, MCU_nBLE,
		MCU_FDP, CS_flash1, CS_flash2, CS_RAM);

input GND, Vflash, Vsram;
input [22:1] MCU_A;
inout [15:0] MCU_D;
input MCU_nRD, MCU_nWR, MCU_nBHE, MCU_nBLE, MCU_FDP;
input CS_flash1, CS_flash2, CS_RAM;

wire WP_ACC;

S71PL129N_plus chip (.Flash_Vcc(Vflash),
		     .RAM_Vcc(Vsram),
		     .Vss(GND),
		     .A(MCU_A),
		     .DQ(MCU_D),
		     .OE(MCU_nRD),
		     .WE(MCU_nWR),
		     .Flash_CE1(CS_flash1),
		     .Flash_CE2(CS_flash2),
		     .Flash_RST(MCU_FDP),
		     .Flash_WP_ACC(WP_ACC),
		     .Flash_ready_busy(),	/* no connect */
		     .RAM_CE_actlow(CS_RAM),
		     .RAM_CE_acthigh(Vflash),	/* per Openmoko */
		     .RAM_UB(MCU_nBHE),
		     .RAM_LB(MCU_nBLE),
		     /* connections to NC/RFU balls per Openmoko */
		     .extra_G8(Vflash),
		     .extra_H9(Vflash),
		     .extra_K6(Vsram),
		     .extra_L5(Vflash)
	);

/* WP_ACC pulled up through a resistor per Openmoko */
resistor Om_R2003 (WP_ACC, Vflash);

/* bypass caps */
capacitor C318 (Vsram, GND);
capacitor C322 (Vflash, GND);

endmodule
