/*
 * This module captures the mysterious all-passive circuit between Iota's
 * AFC output and Rita's XIN input as depicted on the Leonardo schematics.
 * This circuit defies understanding, but it appears in Openmoko's GSM
 * modem (unchanged from Leonardo) and that modem works, hence we deem
 * this voodoo circuit to be suitable for mindless copying w/o understanding...
 *
 * Note that C205 is not included here, as it's already been included
 * in the abb_block wrapper instead.
 */

module int_vcxo_passive (AFC_in, XIN_connection, GND);

input AFC_in, GND;
inout XIN_connection;

wire R217_to_xtal, xtal_to_R211, R211_to_C225;

resistor R217 (AFC_in, R217_to_xtal);
varactor_diode D200 (.Cathode(R217_to_xtal), .Anode(GND));
capacitor C226 (R217_to_xtal, GND);
xtal_4pin_pkg xtal (.pin_1(xtal_to_R211), .pin_2(GND),
		    .pin_3(R217_to_xtal), .pin_4(GND));
resistor R211 (xtal_to_R211, R211_to_C225);
capacitor C224 (R211_to_C225, GND);
capacitor C225 (R211_to_C225, XIN_connection);

endmodule
