/*
 * This module encapsulates the Calypso DBB chip plus the following:
 *
 * - star points and bypass capacitors for the powering arrangement;
 * - the 32 kHz xtal circuit with its special ground;
 * - nIBOOT pull-up and pull-down resistor footprints;
 * - IDDQ, SIM_CD and SIM_PWCTRL tie-offs;
 * - nBSCAN and nEMU[1:0] no-connects.
 *
 * All other Calypso signals are passed through untouched.
 */

module dbb_block (GND, Vdbb, Vio, Vflash, Vrtc,
		  TSPCLKX, TSPDO, TSPDI_IO4, TSPEN, TSPACT,
		  DATA, ADD, RnW, nFWE, nFOE, FDP, nBLE, nBHE, nCS,
		  SCLK, SDO, SDI_SDA, nSCS0_SCL, nSCS1,
		  TX_IRDA, RX_IRDA, TXIR_IRDA, RXIR_IRDA, SD_IRDA,
		  TX_MODEM, RX_MODEM, RTS_MODEM, CTS_MODEM, DSR_LPG,
		  MCSI_TXD, MCSI_RXD, MCSI_CLK, MCSI_FSYNCH,
		  KBC, KBR, BU_PWT, LT_PWL, GPIO,
		  nRESET_OUT_IO7, CLKTCXO,
		  CLK32K_OUT, CLK13M_OUT, nRESPWON, EXT_FIQ, EXT_IRQ,
		  TCXOEN, RFEN, ON_OFF, IT_WAKEUP,
		  TDI, TDO, TCK, TMS,
		  BFSR, BDR, BFSX, BDX, BCLKX_IO6, BCLKR_ARMCLK,
		  VDX, VDR, VFSRX, VCLKRX,
		  MCUDI, MCUDO, MCUEN0, MCUEN1_IO8, MCUEN2_IO13,
		  SIM_IO, SIM_CLK, SIM_RST);

input GND, Vdbb, Vio, Vflash, Vrtc;

output TSPCLKX, TSPDO;
inout TSPDI_IO4;
output [3:0] TSPEN;
output [11:0] TSPACT;

inout [15:0] DATA;
output [22:0] ADD;
output RnW, nFWE, nFOE, FDP, nBLE, nBHE;
output [4:0] nCS;

output SCLK, SDO, nSCS1;
inout SDI_SDA, nSCS0_SCL;

output TX_IRDA, TXIR_IRDA, SD_IRDA, TX_MODEM, RTS_MODEM;
input RX_IRDA, RXIR_IRDA, RX_MODEM, CTS_MODEM;
inout DSR_LPG;

output MCSI_TXD;
input MCSI_RXD;
inout MCSI_CLK, MCSI_FSYNCH;

output [4:0] KBC;
input [4:0] KBR;
output BU_PWT, LT_PWL;
inout [3:0] GPIO;

output nRESET_OUT_IO7;
input CLKTCXO;
output CLK32K_OUT, CLK13M_OUT;
input nRESPWON, EXT_FIQ, EXT_IRQ;

output TCXOEN, RFEN, IT_WAKEUP;
input ON_OFF;

input TDI, TCK, TMS;
output TDO;

input BFSR, BDR;
output BFSX, BDX;
inout BCLKX_IO6;
input BCLKR_ARMCLK;

output VDX;
input VDR, VFSRX, VCLKRX;

input MCUDI;
output MCUDO, MCUEN0, MCUEN1_IO8, MCUEN2_IO13;

inout SIM_IO;
output SIM_CLK, SIM_RST;

/* nets inside this module */
wire nIBOOT, SIM_CD, SIM_PWCTRL;
wire GND_32khz, OSC32K_IN, OSC32K_OUT, OSC32K_OUT_2;
wire VDD_PLL, VDD_CORE;

starpoint HST201 (Vdbb, VDD_PLL);
starpoint HST202 (Vdbb, VDD_CORE);

/* instantiate the Calypso! */

calypso_179ghh calypso (.TSPCLKX(TSPCLKX),
			.TSPDO(TSPDO),
			.TSPDI_IO4(TSPDI_IO4),
			.TSPEN(TSPEN),
			.TSPACT(TSPACT),
			.DATA(DATA),
			.ADD(ADD),
			.RnW(RnW),
			.nFWE(nFWE),
			.nFOE(nFOE),
			.FDP(FDP),
			.nBLE(nBLE),
			.nBHE(nBHE),
			.nCS(nCS),
			.VDDS_MIF(Vflash),
			.VDDS_1(Vio),
			.VDDS_2(Vio),
			.VDD(VDD_CORE),
			.VSS(GND),
			.VDDS_RTC(Vrtc),
			.VDD_RTC(Vrtc),
			.VSS_RTC(GND),
			.VDD_ANG(Vio),
			.VSS_ANG(GND),
			.VDD_PLL(VDD_PLL),
			.VSS_PLL(GND),
			.SCLK(SCLK),
			.SDO(SDO),
			.SDI_SDA(SDI_SDA),
			.nSCS0_SCL(nSCS0_SCL),
			.nSCS1(nSCS1),
			.TX_IRDA(TX_IRDA),
			.RX_IRDA(RX_IRDA),
			.TXIR_IRDA(TXIR_IRDA),
			.RXIR_IRDA(RXIR_IRDA),
			.SD_IRDA(SD_IRDA),
			.TX_MODEM(TX_MODEM),
			.RX_MODEM(RX_MODEM),
			.RTS_MODEM(RTS_MODEM),
			.CTS_MODEM(CTS_MODEM),
			.DSR_LPG(DSR_LPG),
			.MCSI_TXD(MCSI_TXD),
			.MCSI_RXD(MCSI_RXD),
			.MCSI_CLK(MCSI_CLK),
			.MCSI_FSYNCH(MCSI_FSYNCH),
			.KBC(KBC),
			.KBR(KBR),
			.BU_PWT(BU_PWT),
			.LT_PWL(LT_PWL),
			.GPIO(GPIO),
			.nRESET_OUT_IO7(nRESET_OUT_IO7),
			.nIBOOT(nIBOOT),
			.IDDQ(GND),
			.CLKTCXO(CLKTCXO),
			.VSSO(GND_32khz),
			.OSC32K_IN(OSC32K_IN),
			.OSC32K_OUT(OSC32K_OUT),
			.CLK32K_OUT(CLK32K_OUT),
			.CLK13M_OUT(CLK13M_OUT),
			.nRESPWON(nRESPWON),
			.EXT_FIQ(EXT_FIQ),
			.EXT_IRQ(EXT_IRQ),
			.TCXOEN(TCXOEN),
			.RFEN(RFEN),
			.ON_OFF(ON_OFF),
			.IT_WAKEUP(IT_WAKEUP),
			.nEMU(),	/* no connect */
			.nBSCAN(),	/* ditto */
			.TDI(TDI),
			.TDO(TDO),
			.TCK(TCK),
			.TMS(TMS),
			.BFSR(BFSR),
			.BDR(BDR),
			.BFSX(BFSX),
			.BDX(BDX),
			.BCLKX_IO6(BCLKX_IO6),
			.BCLKR_ARMCLK(BCLKR_ARMCLK),
			.VDX(VDX),
			.VDR(VDR),
			.VFSRX(VFSRX),
			.VCLKRX(VCLKRX),
			.MCUDI(MCUDI),
			.MCUDO(MCUDO),
			.MCUEN0(MCUEN0),
			.MCUEN1_IO8(MCUEN1_IO8),
			.MCUEN2_IO13(MCUEN2_IO13),
			.SIM_IO(SIM_IO),
			.SIM_CLK(SIM_CLK),
			.SIM_RST(SIM_RST),
			.SIM_CD(SIM_CD),
			.SIM_PWCTRL_IO5(SIM_PWCTRL));

/* power bypass caps, absolutely unchanged from Leonardo */

capacitor C209 (Vflash, GND);
capacitor C210 (Vio, GND);
capacitor C211 (VDD_CORE, GND);
capacitor C212 (VDD_PLL, GND);

/* 32.768 kHz xtal circuit, following Leonardo schematics */

/* special ground */
starpoint HST203 (GND, GND_32khz);

/* resistor and extra cap on OSC32K_OUT */
resistor R215 (OSC32K_OUT, OSC32K_OUT_2);
capacitor C223 (OSC32K_OUT, GND);	/* regular GND per Leonardo schem */

/* actual xtal and caps */
xtal_32khz_wrap xtal (OSC32K_IN, OSC32K_OUT_2, GND);	/* pkg case GND */
capacitor C202 (OSC32K_IN, GND_32khz);
capacitor C203 (OSC32K_OUT_2, GND_32khz);

/* Vrtc bypass cap */
capacitor C201 (Vrtc, GND_32khz);

/* SIM_PWCTRL resistor like on Leonardo schematics */
resistor R207 (SIM_PWCTRL, SIM_IO);

/* Openmoko added a physical 0R for SIM_CD */
resistor Om_R1001 (SIM_CD, Vio);

/* nIBOOT pull-up and pull-down resistor footprints */
/* the pull-up option has been eliminated in Openmoko's version */
/* resistor R327 (nIBOOT, Vio); */
resistor R328 (nIBOOT, GND);

endmodule
