/*
 * This module encapsulates the holy grail of the FreeCalypso hardware
 * subproject: the Calypso modem block that can also serve as the core
 * for a "dumbphone" design.
 */

module core (GND, VBAT1, VBAT2, VBAT3, VSIM, Vio,
	     PWON, RPWON, nTESTRESET, ON_nOFF,
	     TDI, TDO, TCK, TMS,
	     SCLK, SDO, SDI_SDA, nSCS0_SCL, nSCS1,
	     TX_IRDA, RX_IRDA, TXIR_IRDA, RXIR_IRDA, SD_IRDA,
	     TX_MODEM, RX_MODEM, RTS_MODEM, CTS_MODEM, DSR_LPG,
	     MCSI_TXD, MCSI_RXD, MCSI_CLK, MCSI_FSYNCH,
	     KBC, KBR, BU_PWT, LT_PWL,
	     GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, GPIO6, GPIO7_RESETOUT,
	     GPIO8, GPIO13,
	     ADIN1, ADIN2, ADIN3, DAC,
	     AUXI, AUXON, AUXOP, EARN, EARP, HSMICBIAS, HSMICP, HSO,
	     MICBIAS, MICIN, MICIP,
	     LED_A, LED_B, LED_C,
	     ICTL, PCHG, VBACKUP, VBATS, VCCS, VCHG,
	     SIM_IO, SIM_CLK, SIM_RST, ANTENNA);

input GND, VBAT1, VBAT2, VBAT3;
output VSIM, Vio;

input PWON, RPWON, nTESTRESET;
output ON_nOFF;

input TDI, TCK, TMS;
output TDO;

output SCLK, SDO, nSCS1;
inout SDI_SDA, nSCS0_SCL;

output TX_IRDA, TXIR_IRDA, SD_IRDA, TX_MODEM, RTS_MODEM;
input RX_IRDA, RXIR_IRDA, RX_MODEM, CTS_MODEM;
inout DSR_LPG;

output MCSI_TXD;
input MCSI_RXD;
inout MCSI_CLK, MCSI_FSYNCH;

output [4:0] KBC;
input [4:0] KBR;
output BU_PWT, LT_PWL;

inout GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, GPIO6, GPIO7_RESETOUT, GPIO8, GPIO13;

input ADIN1, ADIN2, ADIN3;
output DAC;

input AUXI;
output AUXON, AUXOP;
output EARN, EARP;
output HSMICBIAS, HSO;
input HSMICP;
output MICBIAS;
input MICIN, MICIP;

output LED_A, LED_B, LED_C;

output ICTL, PCHG;
input VBACKUP, VBATS, VCCS, VCHG;

output SIM_CLK, SIM_RST;
inout SIM_IO;
inout ANTENNA;

/* wires between baseband and RF */
wire Clock_26MHz_RF_out, Clock_26MHz_DBB_in;
wire Analog_IM, Analog_IP, Analog_QM, Analog_QP;
wire AFC, APC;
wire TCXOEN, RFEN, TSPCLK, TSPDO, TSPEN_Rita;
wire [11:0] TSPACT;
wire ADIN4;

/* wires between baseband and memory */
wire Vflash, Vsram;
wire [22:0] MCU_A;
wire [15:0] MCU_D;
wire MCU_RnW, MCU_nFWE, MCU_nFOE;
wire MCU_FDP, MCU_nBLE, MCU_nBHE;
wire CS_flash1, CS_flash2, CS_RAM;

/* instantiate the blocks! */

baseband bb (.GND(GND),
	     .VBAT(VBAT1),
	     .VSIM(VSIM),
	     .Vio(Vio),
	     .Vflash(Vflash),
	     .Vsram(Vsram),
	     .PWON(PWON),
	     .RPWON(RPWON),
	     .nTESTRESET(nTESTRESET),
	     .ON_nOFF(ON_nOFF),
	     .CLKTCXO_IN(Clock_26MHz_DBB_in),
	     .TDI(TDI),
	     .TDO(TDO),
	     .TCK(TCK),
	     .TMS(TMS),
	     .MCU_A(MCU_A),
	     .MCU_D(MCU_D),
	     .MCU_RnW(MCU_RnW),
	     .MCU_nFWE(MCU_nFWE),
	     .MCU_nFOE(MCU_nFOE),
	     .MCU_FDP(MCU_FDP),
	     .MCU_nBLE(MCU_nBLE),
	     .MCU_nBHE(MCU_nBHE),
	     .MCU_nCS[0](CS_flash1),
	     .MCU_nCS[1](CS_RAM),
	     .MCU_nCS[2](CS_flash2),
	     .MCU_nCS[3](),
	     .MCU_nCS[4](),
	     .SCLK(SCLK),
	     .SDO(SDO),
	     .SDI_SDA(SDI_SDA),
	     .nSCS0_SCL(nSCS0_SCL),
	     .nSCS1(nSCS1),
	     .TX_IRDA(TX_IRDA),
	     .RX_IRDA(RX_IRDA),
	     .TXIR_IRDA(TXIR_IRDA),
	     .RXIR_IRDA(RXIR_IRDA),
	     .SD_IRDA(SD_IRDA),
	     .TX_MODEM(TX_MODEM),
	     .RX_MODEM(RX_MODEM),
	     .RTS_MODEM(RTS_MODEM),
	     .CTS_MODEM(CTS_MODEM),
	     .DSR_LPG(DSR_LPG),
	     .MCSI_TXD(MCSI_TXD),
	     .MCSI_RXD(MCSI_RXD),
	     .MCSI_CLK(MCSI_CLK),
	     .MCSI_FSYNCH(MCSI_FSYNCH),
	     .KBC(KBC),
	     .KBR(KBR),
	     .BU_PWT(BU_PWT),
	     .LT_PWL(LT_PWL),
	     .GPIO0(GPIO0),
	     .GPIO1(GPIO1),
	     .GPIO2(GPIO2),
	     .GPIO3(GPIO3),
	     .GPIO4(GPIO4),
	     .GPIO6(GPIO6),
	     .GPIO7_RESETOUT(GPIO7_RESETOUT),
	     .GPIO8(GPIO8),
	     .GPIO13(GPIO13),
	     .ADIN1(ADIN1),
	     .ADIN2(ADIN2),
	     .ADIN3(ADIN3),
	     .ADIN4(ADIN4),
	     .DAC(DAC),
	     .AUXI(AUXI),
	     .AUXON(AUXON),
	     .AUXOP(AUXOP),
	     .EARN(EARN),
	     .EARP(EARP),
	     .HSMICBIAS(HSMICBIAS),
	     .HSMICP(HSMICP),
	     .HSO(HSO),
	     .MICBIAS(MICBIAS),
	     .MICIN(MICIN),
	     .MICIP(MICIP),
	     .LED_A(LED_A),
	     .LED_B(LED_B),
	     .LED_C(LED_C),
	     .ICTL(ICTL),
	     .PCHG(PCHG),
	     .VBACKUP(VBACKUP),
	     .VBATS(VBATS),
	     .VCCS(VCCS),
	     .VCHG(VCHG),
	     .SIM_IO(SIM_IO),
	     .SIM_CLK(SIM_CLK),
	     .SIM_RST(SIM_RST),
	     .Analog_IM(Analog_IM),
	     .Analog_IP(Analog_IP),
	     .Analog_QM(Analog_QM),
	     .Analog_QP(Analog_QP),
	     .AFC(AFC),
	     .APC(APC),
	     .TCXOEN(TCXOEN),
	     .RFEN(RFEN),
	     .TSPCLK(TSPCLK),
	     .TSPDO(TSPDO),
	     .TSPEN_Rita(TSPEN_Rita),
	     .TSPACT(TSPACT)
	);

memory mem (.GND(GND),
	    .Vflash(Vflash),
	    .Vsram(Vsram),
	    .MCU_A(MCU_A[22:1]),
	    .MCU_D(MCU_D[15:0]),
	    .MCU_nRD(MCU_nFOE),
	    .MCU_nWR(MCU_RnW),
	    .MCU_nBHE(MCU_nBHE),
	    .MCU_nBLE(MCU_nBLE),
	    .MCU_FDP(MCU_FDP),
	    .CS_flash1(CS_flash1),
	    .CS_flash2(CS_flash2),
	    .CS_RAM(CS_RAM)
	);

rf_section rf  (.GND(GND),
		.VBAT_REG(VBAT2),
		.VBAT_PA(VBAT3),
		.Vio(Vio),
		.Analog_IM(Analog_IM),
		.Analog_IP(Analog_IP),
		.Analog_QM(Analog_QM),
		.Analog_QP(Analog_QP),
		.AFC(AFC),
		.APC(APC),
		.TCXOEN(TCXOEN),
		.RFEN(RFEN),
		.TSPCLK(TSPCLK),
		.TSPDO(TSPDO),
		.TSPEN_Rita(TSPEN_Rita),
		.TSPACT(TSPACT),
		.Clock_out_to_DBB(Clock_26MHz_RF_out),
		.RTEMP_VTEST(ADIN4),
		.ANTENNA(ANTENNA)
	);

clock_rf2dbb clock_rf2dbb (.In(Clock_26MHz_RF_out),
			   .Out(Clock_26MHz_DBB_in)
		);

endmodule
