/*
 * This module encapsulates the DBB, the ABB and the connections between
 * them.  It approximately corresponds to the "200 - Baseband" sheet
 * in the original Leonardo schematics.
 */

module baseband (GND, VBAT, VSIM, Vio, Vflash, Vsram,
		 PWON, RPWON, nTESTRESET, ON_nOFF, CLKTCXO_IN,
		 TDI, TDO, TCK, TMS,
		 MCU_A, MCU_D, MCU_RnW, MCU_nFWE, MCU_nFOE, MCU_FDP,
		 MCU_nBLE, MCU_nBHE, MCU_nCS,
		 SCLK, SDO, SDI_SDA, nSCS0_SCL, nSCS1,
		 TX_IRDA, RX_IRDA, TXIR_IRDA, RXIR_IRDA, SD_IRDA,
		 TX_MODEM, RX_MODEM, RTS_MODEM, CTS_MODEM, DSR_LPG,
		 MCSI_TXD, MCSI_RXD, MCSI_CLK, MCSI_FSYNCH,
		 KBC, KBR, BU_PWT, LT_PWL,
		 GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, GPIO6, GPIO7_RESETOUT,
		 GPIO8, GPIO13,
		 ADIN1, ADIN2, ADIN3, ADIN4, DAC,
		 AUXI, AUXON, AUXOP, EARN, EARP, HSMICBIAS, HSMICP, HSO,
		 MICBIAS, MICIN, MICIP,
		 LED_A, LED_B, LED_C,
		 ICTL, PCHG, VBACKUP, VBATS, VCCS, VCHG,
		 SIM_IO, SIM_CLK, SIM_RST,
		 Analog_IM, Analog_IP, Analog_QM, Analog_QP, AFC, APC,
		 TCXOEN, RFEN, TSPCLK, TSPDO, TSPEN_Rita, TSPACT);

input GND, VBAT;
output VSIM, Vio, Vflash, Vsram;

input PWON, RPWON, nTESTRESET;
output ON_nOFF;

input CLKTCXO_IN;

input TDI, TCK, TMS;
output TDO;

output [22:0] MCU_A;
inout [15:0] MCU_D;
output MCU_RnW, MCU_nFWE, MCU_nFOE, MCU_FDP, MCU_nBLE, MCU_nBHE;
output [4:0] MCU_nCS;

output SCLK, SDO, nSCS1;
inout SDI_SDA, nSCS0_SCL;

output TX_IRDA, TXIR_IRDA, SD_IRDA, TX_MODEM, RTS_MODEM;
input RX_IRDA, RXIR_IRDA, RX_MODEM, CTS_MODEM;
inout DSR_LPG;

output MCSI_TXD;
input MCSI_RXD;
inout MCSI_CLK, MCSI_FSYNCH;

output [4:0] KBC;
input [4:0] KBR;
output BU_PWT, LT_PWL;

inout GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, GPIO6, GPIO7_RESETOUT, GPIO8, GPIO13;

input ADIN1, ADIN2, ADIN3, ADIN4;
output DAC;

input AUXI;
output AUXON, AUXOP;
output EARN, EARP;
output HSMICBIAS, HSO;
input HSMICP;
output MICBIAS;
input MICIN, MICIP;

output LED_A, LED_B, LED_C;

output ICTL, PCHG;
input VBACKUP, VBATS, VCCS, VCHG;

output SIM_CLK, SIM_RST;
inout SIM_IO;

inout Analog_IM, Analog_IP, Analog_QM, Analog_QP;
output AFC, APC;
output TCXOEN, RFEN, TSPCLK, TSPDO, TSPEN_Rita;
output [11:0] TSPACT;

/* nets between DBB and ABB */
wire Vdbb, Vrtc;
wire CLK13M_OUT, CLK32K_OUT, nRESPWON, IT_WAKEUP;
wire EXT_FIQ, EXT_IRQ;
wire TSPEN_Iota;

/* Baseband serial port */
wire BSP_dbb2abb_data, BSP_dbb2abb_sync;
wire BSP_abb2dbb_data, BSP_abb2dbb_sync;

/* Voiceband serial port */
wire VSP_DL_data, VSP_UL_data;
wire VSP_clock, VSP_sync;

/* MCU serial port */
wire USP_dbb2abb_data, USP_abb2dbb_data, USP_enable;

/* SIM interface at Vio */
wire DBBSIO, DBBSCLK, DBBSRST;

/* instantiate the DBB and ABB blocks! */

dbb_block dbb ( .GND(GND),
		.Vdbb(Vdbb),
		.Vio(Vio),
		.Vflash(Vflash),
		.Vrtc(Vrtc),
		.TSPCLKX(TSPCLK),
		.TSPDO(TSPDO),
		.TSPDI_IO4(GPIO4),
		.TSPEN[0](TSPEN_Iota),
		.TSPEN[1](),		/* no connect */
		.TSPEN[2](TSPEN_Rita),
		.TSPEN[3](),		/* no connect */
		.TSPACT(TSPACT),
		.DATA(MCU_D),
		.ADD(MCU_A),
		.RnW(MCU_RnW),
		.nFWE(MCU_nFWE),
		.nFOE(MCU_nFOE),
		.FDP(MCU_FDP),
		.nBLE(MCU_nBLE),
		.nBHE(MCU_nBHE),
		.nCS(MCU_nCS),
		.SCLK(SCLK),
		.SDO(SDO),
		.SDI_SDA(SDI_SDA),
		.nSCS0_SCL(nSCS0_SCL),
		.nSCS1(nSCS1),
		.TX_IRDA(TX_IRDA),
		.RX_IRDA(RX_IRDA),
		.TXIR_IRDA(TXIR_IRDA),
		.RXIR_IRDA(RXIR_IRDA),
		.SD_IRDA(SD_IRDA),
		.TX_MODEM(TX_MODEM),
		.RX_MODEM(RX_MODEM),
		.RTS_MODEM(RTS_MODEM),
		.CTS_MODEM(CTS_MODEM),
		.DSR_LPG(DSR_LPG),
		.MCSI_TXD(MCSI_TXD),
		.MCSI_RXD(MCSI_RXD),
		.MCSI_CLK(MCSI_CLK),
		.MCSI_FSYNCH(MCSI_FSYNCH),
		.KBC(KBC),
		.KBR(KBR),
		.BU_PWT(BU_PWT),
		.LT_PWL(LT_PWL),
		.GPIO[0](GPIO0),
		.GPIO[1](GPIO1),
		.GPIO[2](GPIO2),
		.GPIO[3](GPIO3),
		.nRESET_OUT_IO7(GPIO7_RESETOUT),
		.CLKTCXO(CLKTCXO_IN),
		.CLK32K_OUT(CLK32K_OUT),
		.CLK13M_OUT(CLK13M_OUT),
		.nRESPWON(nRESPWON),
		.EXT_FIQ(EXT_FIQ),
		.EXT_IRQ(EXT_IRQ),
		.TCXOEN(TCXOEN),
		.RFEN(RFEN),
		.ON_OFF(ON_nOFF),
		.IT_WAKEUP(IT_WAKEUP),
		.TDI(TDI),
		.TDO(TDO),
		.TCK(TCK),
		.TMS(TMS),
		.BFSR(BSP_abb2dbb_sync),
		.BDR(BSP_abb2dbb_data),
		.BFSX(BSP_dbb2abb_sync),
		.BDX(BSP_dbb2abb_data),
		.BCLKX_IO6(GPIO6),
		.BCLKR_ARMCLK(GND),
		.VDX(VSP_DL_data),
		.VDR(VSP_UL_data),
		.VFSRX(VSP_sync),
		.VCLKRX(VSP_clock),
		.MCUDI(USP_abb2dbb_data),
		.MCUDO(USP_dbb2abb_data),
		.MCUEN0(USP_enable),
		.MCUEN1_IO8(GPIO8),
		.MCUEN2_IO13(GPIO13),
		.SIM_IO(DBBSIO),
		.SIM_CLK(DBBSCLK),
		.SIM_RST(DBBSRST)
	);

abb_block abb ( .GND(GND),
		.VBAT(VBAT),
		.VSIM(VSIM),
		.Vdbb(Vdbb),
		.Vio(Vio),
		.Vflash(Vflash),
		.Vsram(Vsram),
		.Vrtc(Vrtc),
		.nRESPWON(nRESPWON),
		.nTESTRESET(nTESTRESET),
		.Analog_IM(Analog_IM),
		.Analog_IP(Analog_IP),
		.Analog_QM(Analog_QM),
		.Analog_QP(Analog_QP),
		.ADIN1(ADIN1),
		.ADIN2(ADIN2),
		.ADIN3(ADIN3),
		.ADIN4(ADIN4),
		.AFC(AFC),
		.APC(APC),
		.AUXI(AUXI),
		.AUXON(AUXON),
		.AUXOP(AUXOP),
		.BDR(BSP_dbb2abb_data),
		.BDX(BSP_abb2dbb_data),
		.BFSR(BSP_dbb2abb_sync),
		.BFSX(BSP_abb2dbb_sync),
		.CK13M(CLK13M_OUT),
		.CK32K(CLK32K_OUT),
		.DAC(DAC),
		.DBBSCK(DBBSCLK),
		.DBBSIO(DBBSIO),
		.DBBSRST(DBBSRST),
		.EARN(EARN),
		.EARP(EARP),
		.HSMICBIAS(HSMICBIAS),
		.HSMICP(HSMICP),
		.HSO(HSO),
		.ICTL(ICTL),
		.INT1(EXT_FIQ),
		.INT2(EXT_IRQ),
		.ITWAKEUP(IT_WAKEUP),
		.LED_A(LED_A),
		.LED_B(LED_B),
		.LED_C(LED_C),
		.MICBIAS(MICBIAS),
		.MICIN(MICIN),
		.MICIP(MICIP),
		.ON_nOFF(ON_nOFF),
		.PCHG(PCHG),
		.PWON(PWON),
		.RPWON(RPWON),
		.TCK(),		/* no connect */
		.TDI(),		/* no connect */
		.TDO(),		/* no connect */
		.TDR(TSPDO),
		.TEN(TSPEN_Iota),
		.TMS(),		/* no connect */
		.UDR(USP_dbb2abb_data),
		.UDX(USP_abb2dbb_data),
		.UEN(USP_enable),
		.VBACKUP(VBACKUP),
		.VBATS(VBATS),
		.VCCS(VCCS),
		.VCHG(VCHG),
		.VCK(VSP_clock),
		.VDR(VSP_DL_data),
		.VDX(VSP_UL_data),
		.VFS(VSP_sync),
		.SIM_IO(SIM_IO),
		.SIM_CLK(SIM_CLK),
		.SIM_RST(SIM_RST)
	);

/* there needs to be a pull-down resistor on the MCUDI/UDX net */
resistor R216 (USP_abb2dbb_data, GND);

endmodule
