/*
 * In the Leonardo schematics there is an RC network in the analog I&Q
 * signal path between the uplink (BUL[IQ][MP]) outputs from the ABB
 * and the bidirectional signals which connect directly to the RF xcvr
 * and to Iota's downlink (BDL[IQ][MP]) inputs.
 *
 * This structural Verilog module encapsulates the RC network in question;
 * this version matches Openmoko's slot assignment and orientation
 * of the resistor packs.
 */

module abb_rc_network (IM_bidir, IP_bidir, QM_bidir, QP_bidir,
			IM_abbout, IP_abbout, QM_abbout, QP_abbout);

inout IM_bidir, IP_bidir, QM_bidir, QP_bidir;
input IM_abbout, IP_abbout, QM_abbout, QP_abbout;

wire IM_mid, IP_mid, QM_mid, QP_mid;

/* resistors on the outputs from the ABB */
resistor_slot Om_R1016_A (QM_mid, QM_abbout);
resistor_slot Om_R1016_B (QP_mid, QP_abbout);
resistor_slot Om_R1016_C (IM_mid, IM_abbout);
resistor_slot Om_R1016_D (IP_mid, IP_abbout);

/* capacitors in the middle */
capacitor C295 (QM_mid, QP_mid);
capacitor C296 (IM_mid, IP_mid);

/* resistors joining with the bidirectional lines */
resistor_slot Om_R1017_A (QM_bidir, QM_mid);
resistor_slot Om_R1017_B (QP_bidir, QP_mid);
resistor_slot Om_R1017_C (IM_bidir, IM_mid);
resistor_slot Om_R1017_D (IP_bidir, IP_mid);

endmodule
