/* Loudspeaker circuit following Leonardo schematics */

module speaker_block (GND, VBAT, Input_pos, Input_neg, GPIO_enable);

input GND, VBAT;
input Input_pos, Input_neg;
input GPIO_enable;

wire PA_in_pos, PA_in_neg;
wire Out_pos, Out_neg;
wire BYPASS;

/* instantiate the audio PA */
pkg_TPA6203A1 apa (.BYPASS(BYPASS),
		   .GND(GND),
		   .In_neg(PA_in_neg),
		   .In_pos(PA_in_pos),
		   .SHUTDOWN(GPIO_enable),
		   .VDD(VBAT),
		   .Out_pos(Out_pos),
		   .Out_neg(Out_neg)
	);

/* input resistors: the inversion is per Leonardo schematics */
resistor R33xA (Input_pos, PA_in_neg);
resistor R33xB (Input_neg, PA_in_pos);

/* feedback resistors */
resistor R331 (Out_neg, PA_in_pos);
resistor R332 (Out_pos, PA_in_neg);

/* bypass and supply decoupling caps */
capacitor C319 (BYPASS, GND);
capacitor C330 (VBAT, GND);

/* small output capacitors */
capacitor C331 (Out_neg, GND);
capacitor C332 (Out_pos, GND);

/* the speaker itself! */
header_2pin spkr_connector (Out_pos, Out_neg);

/* pull-down on the GPIO control line */
resistor R338 (GPIO_enable, GND);

endmodule
