/*
 * This Verilog module captures the JTAG interface circuit which is depicted
 * on the Leonardo schematics and which appears to have been used on their
 * more complete x-Sample boards as well.
 */

module jtag_if (GND, Vio, nTESTRESET, TDI, TCK, TMS, TDO);

input GND, Vio;

inout nTESTRESET;

output TDI, TCK, TMS;
input TDO;

wire header_pin_2, between_transistors;

header_14pin connector (.pin_1(TMS),
			.pin_2(header_pin_2),
			.pin_3(TDI),
			.pin_4(GND),
			.pin_5(Vio),
			.pin_6(),
			.pin_7(TDO),
			.pin_8(GND),
			.pin_9(TCK),
			.pin_10(GND),
			.pin_11(TCK),
			.pin_12(GND),
			.pin_13(),
			.pin_14()
	);

capacitor C363 (Vio, GND);

capacitor C335 (Vio, header_pin_2);
transistor_slot PNP (.E(Vio),
		     .B(header_pin_2),
		     .C(between_transistors)
	);
transistor_slot NPN (.E(GND),
		     .B(between_transistors),
		     .C(nTESTRESET)
	);

endmodule
