/*
 * This is the top level structural Verilog module for the FCDEV3B board,
 * instantiating the Calypso core and the supporting peripherals.
 */

module board ();

wire GND, VBAT;
wire VSIM, Vio;

wire PWON, RPWON, nTESTRESET, ON_nOFF;

wire TDI, TCK, TMS, TDO;

wire SDI_SDA, GPIO1_SPKR, GPIO3_DTR;

wire TX_IRDA, RX_IRDA;
wire TX_MODEM, RX_MODEM, RTS_MODEM, CTS_MODEM;

wire MCSI_TXD, MCSI_RXD, MCSI_CLK, MCSI_FSYNCH;

wire AUXI, AUXON, AUXOP;
wire EARN, EARP;
wire HSMICBIAS, HSO, HSMICP;
wire MICBIAS, MICIN, MICIP;

wire LED_B;

wire SIM_CLK, SIM_RST, SIM_IO;
wire ANTENNA;

core core (.GND(GND),
	   .VBAT1(VBAT),
	   .VBAT2(VBAT),
	   .VBAT3(VBAT),
	   .VSIM(VSIM),
	   .Vio(Vio),
	   .PWON(PWON),
	   .RPWON(RPWON),
	   .nTESTRESET(nTESTRESET),
	   .ON_nOFF(ON_nOFF),
	   .TDI(TDI),
	   .TDO(TDO),
	   .TCK(TCK),
	   .TMS(TMS),
	   /* uWire/I2C interface unused */
	   .SCLK(),
	   .SDO(),
	   .SDI_SDA(SDI_SDA),	/* pull-up resistor */
	   .nSCS0_SCL(),
	   .nSCS1(),
	   .TX_IRDA(TX_IRDA),
	   .RX_IRDA(RX_IRDA),
	   .TXIR_IRDA(),	/* no connect */
	   .RXIR_IRDA(GND),	/* ground input */
	   .SD_IRDA(),
	   .TX_MODEM(TX_MODEM),
	   .RX_MODEM(RX_MODEM),
	   .RTS_MODEM(RTS_MODEM),
	   .CTS_MODEM(CTS_MODEM),
	   .DSR_LPG(GND),	/* ground input */
	   .MCSI_TXD(MCSI_TXD),
	   .MCSI_RXD(MCSI_RXD),
	   .MCSI_CLK(MCSI_CLK),
	   .MCSI_FSYNCH(MCSI_FSYNCH),
	   /* unused interfaces */
	   .KBC(),
	   .KBR(),
	   .BU_PWT(),
	   .LT_PWL(),
	   .GPIO0(),
	   .GPIO1(GPIO1_SPKR),
	   .GPIO2(),
	   .GPIO3(GPIO3_DTR),
	   .GPIO4(),
	   .GPIO6(),
	   .GPIO7_RESETOUT(),
	   .GPIO8(),
	   .GPIO13(),
	   .ADIN1(),
	   .ADIN2(),
	   .ADIN3(),
	   .DAC(),
	   /* audio */
	   .AUXI(AUXI),
	   .AUXON(AUXON),
	   .AUXOP(AUXOP),
	   .EARN(EARN),
	   .EARP(EARP),
	   .HSMICBIAS(HSMICBIAS),
	   .HSMICP(HSMICP),
	   .HSO(HSO),
	   .MICBIAS(MICBIAS),
	   .MICIN(MICIN),
	   .MICIP(MICIP),
	   /* unused interfaces */
	   .LED_A(),
	   .LED_B(LED_B),
	   .LED_C(),
	   .ICTL(),
	   .PCHG(),
	   .VBACKUP(),
	   .VBATS(),
	   .VCCS(),
	   .VCHG(),
	   /* SIM and antenna connections */
	   .SIM_IO(SIM_IO),
	   .SIM_CLK(SIM_CLK),
	   .SIM_RST(SIM_RST),
	   .ANTENNA(ANTENNA)
	);

/* power input */
power_in pwr_in (.VBAT(VBAT), .GND(GND));

/* PWON and nTESTRESET pushbuttons */
pushbutton_wrap pwr_btn (PWON, GND);
pushbutton_wrap reset_btn (nTESTRESET, GND);
/* PWON jumper option */
header_2pin PWON_jumper (PWON, GND);

/* RF output */
sma_wrap SMA (.Center(ANTENNA), .Shell(GND));

/* SIM socket */
sim_socket_block sim (.GND(GND),
		      .VSIM(VSIM),
		      .SIM_CLK(SIM_CLK),
		      .SIM_RST(SIM_RST),
		      .SIM_IO(SIM_IO)
	);

/* UART interfaces */
uart_bringout uart_if (.GND(GND),
		       .Vio(Vio),
		       .TX_MODEM(TX_MODEM),
		       .RX_MODEM(RX_MODEM),
		       .RTS_MODEM(RTS_MODEM),
		       .CTS_MODEM(CTS_MODEM),
		       .TX_IRDA(TX_IRDA),
		       .RX_IRDA(RX_IRDA)
	);

/* JTAG interface */
jtag_if jtag_if (.GND(GND),
		 .Vio(Vio),
		 .nTESTRESET(nTESTRESET),
		 .TDI(TDI),
		 .TCK(TCK),
		 .TMS(TMS),
		 .TDO(TDO)
	);

/* MCSI interface */
mcsi_if mcsi_if (.GND(GND),
		 .MCSI_TXD(MCSI_TXD),
		 .MCSI_RXD(MCSI_RXD),
		 .MCSI_CLK(MCSI_CLK),
		 .MCSI_FSYNCH(MCSI_FSYNCH)
	);

/* misc pull-up and pull-down resistors */
resistor Om_R1006 (SDI_SDA, Vio);
resistor R100 (GPIO3_DTR, GND);

/* analog microphone circuit */
microphone_block mic (.GND(GND),
		      .MICBIAS(MICBIAS),
		      .MICIN(MICIN),
		      .MICIP(MICIP)
	);

/* loudspeaker circuit */
speaker_block spkr (.GND(GND),
		    .VBAT(VBAT),
		    .Input_pos(EARP),
		    .Input_neg(EARN),
		    .GPIO_enable(GPIO1_SPKR)
	);

/* metal shieldcan */
shieldcan SH1 (.GND(GND));

endmodule
