/*
 * We have the option of using several different physical packages
 * for the 32 kHz crystal resonator.  While the essential connections
 * with any package are the two electrodes, with some packages there is
 * also a ground connection for the package case.  This wrapper will
 * encapsulate the knowledge of where the electrodes and the ground
 * connect.
 *
 * This version is appropriate for MS1V-TK (used on Leonardo) and for
 * MS2V-T1S (used by Openmoko).
 */

module xtal_32khz_wrap (electrode1, electrode2, GND);

input electrode1, electrode2, GND;

xtal_3pin_pkg xtal (electrode1, electrode2, GND);

endmodule
