/*
 * This module encapsulates the Rita chip along with the surrounding entourage
 * of power bypass capacitors; all other Rita signals are passed through
 * unchanged.
 */

module rita_wrap (GND, VBAT, VREG3, VRIO,
		  XEN, XSEL, XIN, Clock_out_to_DBB,
		  Ctrl_CLK, Ctrl_DATA, Ctrl_STROBE, Ctrl_RESETZ,
		  IN, IP, QN, QP,
		  LNAGSMN, LNAGSMP, LNADCSN, LNADCSP, LNAPCSN, LNAPCSP,
		  LBTXOUT, HBTXOUT,
		  DAC, DET1, DET2, APC,
		  RTEMP_VTEST);

input GND, VBAT, VRIO;
output VREG3;

input XEN, XSEL, XIN;
output Clock_out_to_DBB;

input Ctrl_CLK, Ctrl_DATA, Ctrl_STROBE, Ctrl_RESETZ;
inout IN, IP, QN, QP;

input LNAGSMN, LNAGSMP, LNADCSN, LNADCSP, LNAPCSN, LNAPCSP;
output LBTXOUT, HBTXOUT;

input DAC, DET1, DET2;
output APC;

output RTEMP_VTEST;

/* Rita power nets contained inside this wrapper */

wire VREG1, VREG2;
wire VCC4, VCC6, VCC9, VCC11;
wire VBG;

/* instantiate the Rita! */

rita_rf_chip rita (.GND(GND),
		   .CLK(Ctrl_CLK),
		   .DATA(Ctrl_DATA),
		   .STROBE(Ctrl_STROBE),
		   .RESETZ(Ctrl_RESETZ),
		   .IN(IN),
		   .IP(IP),
		   .QN(QN),
		   .QP(QP),
		   .LNAGSMN(LNAGSMN),
		   .LNAGSMP(LNAGSMP),
		   .LNADCSN(LNADCSN),
		   .LNADCSP(LNADCSP),
		   .LNAPCSN(LNAPCSN),
		   .LNAPCSP(LNAPCSP),
		   .LBTXOUT(LBTXOUT),
		   .HBTXOUT(HBTXOUT),
		   .DAC(DAC),
		   .DET1(DET1),
		   .DET2(DET2),
		   .APC(APC),
		   .RTEMP_VTEST(RTEMP_VTEST),
		   .SIOUT_TST(),	/* no connect */
		   .TSTVCO1(),		/* ditto */
		   .TSTVCO2(),		/* "" */
		   .VBAT1(VBAT),
		   .VBAT2(VBAT),
		   .VREG1(VREG1),
		   .VREG2(VREG2),
		   .VREG3(VREG3),
		   .VRIO(VRIO),
		   .VCC1(VREG2),
		   .VCC2(VREG2),
		   .VCC3(VREG2),
		   .VCC4(VCC4),
		   .VCC5(VREG2),
		   .VCC6(VCC6),
		   .VCC7(VREG1),
		   .VCC8(VREG3),
		   .VCC9(VCC9),
		   .VCC10(VREG3),
		   .VCC11(VCC11),
		   .VCC12(VREG1),
		   .VCC13(VREG1),
		   .VBG(VBG),
		   .XEN(XEN),
		   .XSEL(XSEL),
		   .XIN(XIN),
		   .XOUT(Clock_out_to_DBB)
		);

/* bypass caps on VREGn */
capacitor C619 (VREG1, GND);
capacitor C622 (VREG2, GND);
capacitor C613 (VREG3, GND);

/* caps on VCCn */

/* VCC1  */ capacitor C629 (VREG2, GND);
/* VCC2  */ capacitor C630 (VREG2, GND);
/* VCC3  */ capacitor C631 (VREG2, GND);
/* VCC4  */ capacitor C632 (VCC4,  GND);
/* VCC5  */ capacitor C633 (VREG2, GND);
/* VCC6  */ capacitor C634 (VCC6,  GND);
/* VCC7  */ capacitor C620 (VREG1, GND);
/* VCC8  */ capacitor C609 (VREG3, GND);
/* VCC9  */ capacitor C608 (VCC9,  GND);
/* VCC10 */ capacitor C607 (VREG3, GND);
/* VCC11 */ capacitor C606 (VCC11, GND);
/* VCC12 */ capacitor C610 (VREG1, GND);
/* VCC13 */ capacitor C617 (VREG1, GND);

capacitor C616 (VBG, GND);

/*
 * Some Leonardo schematic versions show two caps instead of one,
 * and Openmoko kept that configuration.
 */
capacitor XEN_cap (XEN, GND);
capacitor XEN_cap2 (XEN, GND);

endmodule
