/*
 * This module encapsulates the Rita block (Rita chip + caps) together with
 * the choice of internal or external VC(TC)XO; this version is for the
 * external configuration.
 */

module rita_vcxo_ext (GND, VBAT, VREG3, VRIO,
		      TCXOEN, RFEN, AFC_in, Clock_out_to_DBB,
		      Ctrl_CLK, Ctrl_DATA, Ctrl_STROBE, Ctrl_RESETZ,
		      IN, IP, QN, QP,
		      LNAGSMN, LNAGSMP, LNADCSN, LNADCSP, LNAPCSN, LNAPCSP,
		      LBTXOUT, HBTXOUT,
		      DAC, DET1, DET2, APC,
		      RTEMP_VTEST);

input GND, VBAT, VRIO;
output VREG3;

input TCXOEN, RFEN, AFC_in;
output Clock_out_to_DBB;

input Ctrl_CLK, Ctrl_DATA, Ctrl_STROBE, Ctrl_RESETZ;
inout IN, IP, QN, QP;

input LNAGSMN, LNAGSMP, LNADCSN, LNADCSP, LNAPCSN, LNAPCSP;
output LBTXOUT, HBTXOUT;

input DAC, DET1, DET2;
output APC;

output RTEMP_VTEST;

/* external VCTCXO configuration */

wire VCTCXO_output;

ext_vctcxo vctcxo (.GND(GND),
		   .VCTCXO_power(TCXOEN),
		   .AFC_in(AFC_in),
		   .Out(VCTCXO_output)
		);

/* instantiate the Rita block */

rita_wrap rita (.GND(GND),
		.VBAT(VBAT),
		.VREG3(VREG3),
		.VRIO(VRIO),
		.XEN(RFEN),
		.XSEL(GND),
		.XIN(VCTCXO_output),
		.Clock_out_to_DBB(Clock_out_to_DBB),
		.Ctrl_CLK(Ctrl_CLK),
		.Ctrl_DATA(Ctrl_DATA),
		.Ctrl_STROBE(Ctrl_STROBE),
		.Ctrl_RESETZ(Ctrl_RESETZ),
		.IN(IN),
		.IP(IP),
		.QN(QN),
		.QP(QP),
		.LNAGSMN(LNAGSMN),
		.LNAGSMP(LNAGSMP),
		.LNADCSN(LNADCSN),
		.LNADCSP(LNADCSP),
		.LNAPCSN(LNAPCSN),
		.LNAPCSP(LNAPCSP),
		.LBTXOUT(LBTXOUT),
		.HBTXOUT(HBTXOUT),
		.DAC(DAC),
		.DET1(DET1),
		.DET2(DET2),
		.APC(APC),
		.RTEMP_VTEST(RTEMP_VTEST)
	);

endmodule
