/*
 * This Verilog module captures the Rx matching network found in Openmoko's
 * triband modem between each SAW filter output and each Rita LNA input pair,
 * same for all 3 bands.
 */

module rfmatch_fem2rita_om (In_neg, In_pos, Out_neg, Out_pos);

input In_neg, In_pos;
output Out_neg, Out_pos;

capacitor C_in (In_neg, In_pos);

inductor L_neg (In_neg, Out_neg);
inductor L_pos (In_pos, Out_pos);

capacitor C_out (Out_neg, Out_pos);

endmodule
