/*
 * This is the Openmoko-mimicking triband version of the rf_fem_block module,
 * using separate antenna switch and SAW filter components.
 */

module rf_fem_block (GND, VREG3, Om_TSPACT2, Om_TSPACT4, Om_TSPACT1,
		     GSMout_neg, GSMout_pos, DCSout_neg, DCSout_pos,
		     PCSout_neg, PCSout_pos,
		     TX_LOW, TX_HIGH, ANT);

input GND, VREG3;
input Om_TSPACT2, Om_TSPACT4, Om_TSPACT1;

output GSMout_neg, GSMout_pos, DCSout_neg, DCSout_pos, PCSout_neg, PCSout_pos;
input TX_LOW, TX_HIGH;
inout ANT;

wire ANT_before_cap;
wire GSM_Rx_single, DCS_Rx_single, PCS_Rx_single;
wire VC1, VC2, VC3;

/* transform control signals through PNP transistors */

transistor_slot PNP_VC1 (.E(VREG3), .B(Om_TSPACT2), .C(VC1));
transistor_slot PNP_VC2 (.E(VREG3), .B(Om_TSPACT1), .C(VC2));
transistor_slot PNP_VC3 (.E(VREG3), .B(Om_TSPACT4), .C(VC3));

/* instantiate the antenna switch */

antenna_switch ant_sw  (.ANT(ANT_before_cap),
			.GND(GND),
			.RX_LOW(GSM_Rx_single),
			.RX_DCS(DCS_Rx_single),
			.RX_PCS(PCS_Rx_single),
			.TX_LOW(TX_LOW),
			.TX_HIGH(TX_HIGH),
			.VC1(VC1),
			.VC2(VC2),
			.VC3(VC3)
	);

/* SAW filters */

saw_filter U402 (.In_single(GSM_Rx_single),
		 .Out_neg(GSMout_neg),
		 .Out_pos(GSMout_pos),
		 .GND(GND)
	);

saw_filter U403 (.In_single(DCS_Rx_single),
		 .Out_neg(DCSout_neg),
		 .Out_pos(DCSout_pos),
		 .GND(GND)
	);

saw_filter U404 (.In_single(PCS_Rx_single),
		 .Out_neg(PCSout_neg),
		 .Out_pos(PCSout_pos),
		 .GND(GND)
	);

capacitor C401 (ANT_before_cap, ANT);

capacitor C402 (VC1, GND);
capacitor C403 (VC3, GND);
capacitor C404 (VC2, GND);

endmodule
